<?php 
include 'koneksi.php'; 
// Proteksi: Hanya Admin yang bisa mengakses halaman ini
if($_SESSION['role'] !== 'admin'){ 
    header('location:index.php'); 
    exit; 
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Guru - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        :root { --primary-color: #006400; --sidebar-bg: #1a1a1a; }
        body { background-color: #f4f7f6; font-family: 'Segoe UI', sans-serif; overflow-x: hidden; }
        
        /* Sidebar Styling */
        .sidebar { background: var(--sidebar-bg); min-height: 100vh; position: fixed; width: 240px; z-index: 100; }
        .sidebar .nav-link { color: #adb5bd; padding: 12px 20px; margin: 4px 15px; border-radius: 8px; font-weight: 500; text-decoration: none; display: block; }
        .sidebar .nav-link:hover { background: rgba(255,255,255,0.05); color: #fff; }
        .sidebar .nav-link.active { background: var(--primary-color); color: #fff; box-shadow: 0 4px 12px rgba(0,100,0,0.3); }
        .sidebar-brand { padding: 30px 25px; color: #fff; font-size: 1.2rem; border-bottom: 1px solid rgba(255,255,255,0.1); margin-bottom: 20px; }

        /* Main Content Styling */
        .main-content { margin-left: 240px; padding: 40px; }
        .table-box { background: #fff; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.03); padding: 25px; }
        
        .badge-user { background: #e8f5e9; color: #2e7d32; border: 1px solid #c8e6c9; }
        .badge-admin { background: #ffebee; color: #c62828; border: 1px solid #ffcdd2; }
        
        @media (max-width: 992px) {
            .sidebar { width: 70px; }
            .sidebar .nav-link span, .sidebar-brand span { display: none; }
            .main-content { margin-left: 70px; }
        }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-brand fw-bold">
            <i class="bi bi-shield-check text-success me-2"></i><span>ADMIN PANEL</span>
        </div>
        <nav class="nav flex-column">
            <a href="tampil_laporan.php" class="nav-link">
                <i class="bi bi-grid-1x2 me-2"></i><span>Dashboard</span>
            </a>
            <a href="daftar_user.php" class="nav-link active">
                <i class="bi bi-people me-2"></i><span>Daftar Guru</span>
            </a>
            <a href="register.php" class="nav-link">
                <i class="bi bi-person-plus me-2"></i><span>Tambah User</span>
            </a>
            <a href="index.php" class="nav-link">
                <i class="bi bi-pencil-square me-2"></i><span>Input Laporan</span>
            </a>
            <div class="mt-5">
                <a href="logout.php" class="nav-link text-danger fw-bold">
                    <i class="bi bi-box-arrow-right me-2"></i><span>Logout</span>
                </a>
            </div>
        </nav>
    </div>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="fw-bold text-dark mb-0">Manajemen Pengguna</h3>
                <p class="text-muted small">Kelola data guru dan hak akses sistem</p>
            </div>
            <a href="register.php" class="btn btn-success rounded-pill px-4 shadow-sm">
                <i class="bi bi-plus-lg me-2"></i>Tambah Guru Baru
            </a>
        </div>

        <div class="table-box">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="text-secondary small">
                        <tr>
                            <th class="border-0">NO</th>
                            <th class="border-0">NAMA LENGKAP</th>
                            <th class="border-0">USERNAME</th>
                            <th class="border-0">WHATSAPP</th>
                            <th class="border-0">ROLE</th>
                            <th class="border-0 text-end">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $query = mysqli_query($conn, "SELECT * FROM users ORDER BY role ASC, nama_lengkap ASC");
                        while($row = mysqli_fetch_assoc($query)){
                            $is_admin = ($row['role'] == 'admin');
                        ?>
                        <tr class="border-bottom">
                            <td><?= $no++; ?></td>
                            <td>
                                <div class="fw-bold text-dark"><?= $row['nama_lengkap']; ?></div>
                                <div class="text-muted" style="font-size: 0.75rem;">ID: #USR-0<?= $row['id']; ?></div>
                            </td>
                            <td><code><?= $row['username']; ?></code></td>
                            <td>
                                <a href="https://wa.me/<?= $row['no_wa']; ?>" target="_blank" class="text-success text-decoration-none">
                                    <i class="bi bi-whatsapp me-1"></i> <?= $row['no_wa']; ?>
                                </a>
                            </td>
                            <td>
                                <span class="badge rounded-pill <?= $is_admin ? 'badge-admin' : 'badge-user'; ?> px-3">
                                    <?= strtoupper($row['role']); ?>
                                </span>
                            </td>
                            <td class="text-end">
                                <a href="edit_user.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-outline-primary border-0 me-1" title="Edit Data">
                                    <i class="bi bi-pencil-square fs-5"></i>
                                </a>

                                <?php if($row['username'] !== $_SESSION['log']): ?>
                                    <a href="hapus_user.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-outline-danger border-0" onclick="return confirm('Apakah Anda yakin ingin menghapus user ini?')" title="Hapus User">
                                        <i class="bi bi-trash3 fs-5"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <p class="mt-4 text-center text-muted small">&copy; 2025 Kemenag Kabupaten Jombang - Monitoring System</p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>