<?php include 'koneksi.php'; if(!isset($_SESSION['log'])){ header('location:login.php'); exit; } ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Report Guru - Kemenag Jombang</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <style>
        :root { --primary: #10b981; }
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background: linear-gradient(-45deg, #064e3b, #059669, #10b981);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            min-height: 100vh;
            color: #1f2937;
        }
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 30px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            padding: 30px;
        }
        .form-control { border-radius: 15px; padding: 12px 18px; border: 2px solid #f3f4f6; background: #f9fafb; }
        .form-control:focus { border-color: var(--primary); box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.1); }
        .btn-camera { 
            background: #f0fdf4; color: #16a34a; border: 2px dashed #16a34a; 
            padding: 20px; border-radius: 20px; cursor: pointer; transition: 0.3s;
        }
        .btn-camera:hover { background: #dcfce7; }
        .btn-submit { 
            background: var(--primary); color: white; border: none; 
            border-radius: 15px; padding: 15px; font-weight: 800; transition: 0.3s; 
        }
        .btn-submit:disabled { background: #9ca3af; transform: none; }
        #image_preview { max-width: 100%; border-radius: 20px; display: none; margin-bottom: 20px; border: 4px solid white; box-shadow: 0 10px 15px rgba(0,0,0,0.1); }
    </style>
</head>
<body>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4 px-2 text-white">
        <span class="fw-800 fs-5"><i class="bi bi-geo-alt-fill me-1"></i> E-REPORT</span>
        <a href="logout.php" class="btn btn-sm btn-light rounded-pill px-3 fw-bold text-danger">Keluar</a>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="glass-card">
                <div class="text-center mb-4">
                    <h4 class="fw-800 mb-1">Input Laporan</h4>
                    <p class="text-muted small">Halo, <b><?= $_SESSION['log']; ?></b>. Pastikan GPS aktif.</p>
                </div>

                <form action="proses_simpan.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="lokasi" id="input_lokasi">

                    <div id="status_gps" class="alert alert-warning border-0 small py-2 mb-3 rounded-4 text-center">
                        <i class="bi bi-broadcast"></i> Mengunci Lokasi GPS...
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold">SEKOLAH TUJUAN</label>
                        <input type="text" name="nama_sekolah" class="form-control" placeholder="Contoh: MTSN 1 Jombang" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold">HASIL KEGIATAN</label>
                        <textarea name="penjelasan" class="form-control" rows="3" placeholder="Apa yang Anda lakukan?" required></textarea>
                    </div>

                    <div class="mb-4 text-center">
                        <img id="image_preview" src="#" alt="Preview">
                        
                        <label for="foto_kamera" class="btn-camera d-block">
                            <i class="bi bi-camera-fill fs-2 d-block mb-1"></i>
                            <span class="small fw-bold">AMBIL FOTO DOKUMENTASI</span>
                        </label>
                        <input type="file" name="foto" id="foto_kamera" class="d-none" accept="image/*" capture="environment" onchange="previewImage(this);" required>
                        <div class="form-text mt-2" style="font-size: 0.7rem;">Sistem akan langsung membuka kamera HP Anda.</div>
                    </div>

                    <button type="submit" name="kirim" id="btn_kirim" class="btn btn-submit w-100 shadow-lg" disabled>
                        MENUNGGU GPS...
                    </button>
                </form>
            </div>

            <p class="text-center text-white-50 small mt-4">
                &copy; 2025 Kemenag Jombang Monitoring System
            </p>
        </div>
    </div>
</div>

<script>
    // PREVIEW GAMBAR
    function previewImage(input) {
        const preview = document.getElementById('image_preview');
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    // GEOLOCATION GPS
    window.onload = function() {
        const inputLokasi = document.getElementById('input_lokasi');
        const statusGps = document.getElementById('status_gps');
        const btnKirim = document.getElementById('btn_kirim');

        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const lat = position.coords.latitude;
                    const lon = position.coords.longitude;
                    inputLokasi.value = lat + "," + lon;
                    
                    statusGps.innerHTML = `<i class="bi bi-check-circle-fill text-success me-1"></i> Lokasi Terkunci: ${lat.toFixed(4)}, ${lon.toFixed(4)}`;
                    statusGps.className = "alert alert-success border-0 small py-2 mb-3 rounded-4 text-center";
                    
                    btnKirim.disabled = false;
                    btnKirim.innerHTML = 'KIRIM LAPORAN SEKARANG <i class="bi bi-send-fill ms-2"></i>';
                },
                (error) => {
                    statusGps.innerHTML = `<i class="bi bi-exclamation-triangle-fill text-danger me-1"></i> GPS Gagal! Aktifkan Lokasi di HP.`;
                    statusGps.className = "alert alert-danger border-0 small py-2 mb-3 rounded-4 text-center";
                },
                { enableHighAccuracy: true }
            );
        } else {
            statusGps.innerHTML = "Browser tidak mendukung GPS.";
        }
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>