<?php include 'koneksi.php'; ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Monitoring Kemenag Jombang</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <style>
        :root {
            --emerald-600: #059669;
            --emerald-700: #047857;
        }
        
        body {
            background: linear-gradient(135deg, #064e3b 0%, #059669 100%);
            font-family: 'Plus Jakarta Sans', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            overflow: hidden;
        }

        .login-container {
            width: 100%;
            max-width: 420px;
            padding: 20px;
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 28px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
            padding: 40px;
            transition: all 0.3s ease;
        }

        .brand-logo {
            width: 80px;
            height: 80px;
            background: #ecfdf5;
            color: var(--emerald-600);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            font-size: 2.5rem;
        }

        .form-label {
            font-weight: 600;
            color: #374151;
            font-size: 0.85rem;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-control {
            border-radius: 14px;
            padding: 12px 16px;
            border: 2px solid #f3f4f6;
            background: #f9fafb;
            transition: all 0.2s;
        }

        .form-control:focus {
            background: #fff;
            border-color: var(--emerald-600);
            box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.1);
        }

        .btn-login {
            background: var(--emerald-600);
            color: white;
            border: none;
            border-radius: 14px;
            padding: 14px;
            font-weight: 700;
            width: 100%;
            margin-top: 10px;
            transition: all 0.3s;
        }

        .btn-login:hover {
            background: var(--emerald-700);
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(16, 185, 129, 0.3);
        }

        .footer-text {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.8rem;
            text-align: center;
            margin-top: 24px;
        }
    </style>
</head>
<body>

<div class="container d-flex justify-content-center">
    <div class="login-container">
        <div class="glass-card">
            <div class="text-center">
                <div class="brand-logo">
                    <i class="bi bi-shield-lock-fill"></i>
                </div>
                <h3 class="fw-800 text-dark mb-1">Selamat Datang</h3>
                <p class="text-muted small mb-4">Silakan masuk ke akun Anda</p>
            </div>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <div class="input-group">
                        <input type="text" name="username" class="form-control" placeholder="Masukkan username" required autofocus>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" placeholder="••••••••" required>
                </div>

                <button type="submit" name="login" class="btn btn-login">
                    MASUK SEKARANG <i class="bi bi-arrow-right ms-2"></i>
                </button>
            </form>

            <?php
            if(isset($_POST['login'])){
                $u = mysqli_real_escape_string($conn, $_POST['username']);
                $p = md5($_POST['password']);
                
                $query = mysqli_query($conn, "SELECT * FROM users WHERE username='$u' AND password='$p'");
                
                if(mysqli_num_rows($query) > 0){
                    $data = mysqli_fetch_assoc($query);
                    $_SESSION['log'] = $data['username'];
                    $_SESSION['role'] = $data['role'];
                    
                    echo "<script>window.location='index.php';</script>";
                } else {
                    echo "
                    <div class='alert alert-danger border-0 mt-3 rounded-4 small py-2 text-center'>
                        <i class='bi bi-exclamation-circle me-1'></i> Username atau Password salah!
                    </div>";
                }
            }
            ?>
        </div>
        <div class="footer-text">
            &copy; 2025 Kemenag Jombang | Monitoring System <br>
            Developed with <i class="bi bi-heart-fill text-danger"></i> for Education
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>