<?php 
include 'koneksi.php'; 
if($_SESSION['role'] != 'admin'){ header('location:index.php'); exit; }

// --- LOGIC STATISTIK ---
$total_laporan = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan"));
$hari_ini = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM laporan WHERE DATE(tanggal_input) = CURDATE()"));
$total_guru = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM users WHERE role='user'"));

// Statistik Sekolah Sering Dikunjungi
$sering_q = mysqli_query($conn, "SELECT nama_sekolah, COUNT(*) as total FROM laporan GROUP BY nama_sekolah ORDER BY total DESC LIMIT 5");
$label_sering = []; $data_sering = [];
while($row = mysqli_fetch_assoc($sering_q)){
    $label_sering[] = $row['nama_sekolah'];
    $data_sering[] = $row['total'];
}

// Statistik Sekolah Jarang Dikunjungi
$jarang_q = mysqli_query($conn, "SELECT nama_sekolah, COUNT(*) as total FROM laporan GROUP BY nama_sekolah HAVING total <= 2 ORDER BY total ASC LIMIT 5");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Monitoring Lokasi</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        :root { --primary: #10b981; --main-bg: #f8fafc; }
        body { background-color: var(--main-bg); font-family: 'Plus Jakarta Sans', sans-serif; color: #1e293b; }
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #fff; border-right: 1px solid #e2e8f0; padding: 24px; z-index: 1000; }
        .nav-link { display: flex; align-items: center; padding: 12px 16px; color: #64748b; font-weight: 600; border-radius: 12px; margin-bottom: 8px; text-decoration: none; }
        .nav-link.active { background: #ecfdf5; color: #059669; }
        .main-content { margin-left: 260px; padding: 40px; }
        .content-card { background: white; border-radius: 24px; padding: 24px; box-shadow: 0 4px 20px rgba(0,0,0,0.03); border: none; }
        .stat-card { background: white; border-radius: 20px; padding: 20px; border: 1px solid #f1f5f9; }
        .img-preview { width: 50px; height: 50px; object-fit: cover; border-radius: 10px; cursor: pointer; }
        .badge-gps { background: #f0fdf4; color: #16a34a; border: 1px solid #bbf7d0; font-size: 0.75rem; padding: 4px 10px; border-radius: 8px; }
        @media (max-width: 992px) { .sidebar { display: none; } .main-content { margin-left: 0; } }
    </style>
</head>
<body>

    <aside class="sidebar no-print">
        <div class="sidebar-brand fw-800 text-success mb-4 fs-5"><i class="bi bi-geo-fill"></i> KEMENAG MONITOR</div>
        <nav class="nav flex-column">
            <a href="tampil_laporan.php" class="nav-link active"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
            <a href="daftar_user.php" class="nav-link"><i class="bi bi-people me-2"></i> Daftar Guru</a>
            <a href="register.php" class="nav-link"><i class="bi bi-person-plus me-2"></i> Tambah User</a>
            <hr>
            <a href="logout.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right me-2"></i> Logout</a>
        </nav>
    </aside>

    <main class="main-content">
        <header class="mb-4 d-flex justify-content-between align-items-center">
            <div>
                <h3 class="fw-800 mb-0">Pemantauan Real-Time</h3>
                <p class="text-muted small">Melihat lokasi dan bukti kunjungan guru di lapangan</p>
            </div>
            <button onclick="window.print()" class="btn btn-dark rounded-pill px-4 shadow-sm no-print">Cetak Laporan</button>
        </header>

        <div class="row g-3 mb-4">
            <div class="col-md-4">
                <div class="stat-card text-center">
                    <h2 class="fw-800 text-success mb-0"><?= $total_laporan; ?></h2>
                    <p class="text-muted small fw-bold mb-0">LAPORAN MASUK</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card text-center">
                    <h2 class="fw-800 text-primary mb-0"><?= $hari_ini; ?></h2>
                    <p class="text-muted small fw-bold mb-0">KUNJUNGI HARI INI</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card text-center">
                    <h2 class="fw-800 text-warning mb-0"><?= $total_guru; ?></h2>
                    <p class="text-muted small fw-bold mb-0">GURU TERDAFTAR</p>
                </div>
            </div>
        </div>

        <div class="row g-4 mb-4 text-center">
            <div class="col-md-12">
                <div class="content-card">
                    <h6 class="fw-800 mb-4 text-start"><i class="bi bi-bar-chart-fill me-2 text-success"></i>Tren Kunjungan Sekolah</h6>
                    <canvas id="chartSekolah" height="80"></canvas>
                </div>
            </div>
        </div>

        <div class="content-card">
            <h6 class="fw-800 mb-4">Aktivitas Terbaru & Posisi GPS</h6>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="bg-light">
                        <tr class="small text-muted text-uppercase">
                            <th class="border-0">Waktu / Tanggal</th>
                            <th class="border-0">Pelapor</th>
                            <th class="border-0">Sekolah Tujuan</th>
                            <th class="border-0">Lokasi GPS</th>
                            <th class="border-0">Foto Dokumentasi</th>
                            <th class="border-0 text-end no-print">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">
                        <?php 
                        $q_table = mysqli_query($conn, "SELECT * FROM laporan ORDER BY id DESC");
                        while($row = mysqli_fetch_assoc($q_table)){
                        ?>
                        <tr>
                            <td>
                                <strong><?= date('H:i', strtotime($row['tanggal_input'])); ?></strong><br>
                                <span class="text-muted"><?= date('d M Y', strtotime($row['tanggal_input'])); ?></span>
                            </td>
                            <td><span class="fw-600"><?= $row['nama_pelapor']; ?></span></td>
                            <td><span class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill"><?= $row['nama_sekolah']; ?></span></td>
                            <td>
                                <?php if(!empty($row['lokasi'])): ?>
                                    <div class="mb-1"><span class="badge-gps"><i class="bi bi-geo-alt-fill"></i> Terkunci</span></div>
                                    <a href="https://www.google.com/maps?q=<?= $row['lokasi']; ?>" target="_blank" class="text-decoration-none text-primary fw-bold">
                                        Lihat di Maps <i class="bi bi-box-arrow-up-right small"></i>
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted italic">Lokasi tidak tersedia</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="uploads/<?= $row['foto']; ?>" target="_blank">
                                    <img src="uploads/<?= $row['foto']; ?>" class="img-preview shadow-sm">
                                </a>
                            </td>
                            <td class="text-end no-print">
                                <a href="hapus.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-light text-danger rounded-circle" onclick="return confirm('Hapus data ini?')"><i class="bi bi-trash"></i></a>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script>
        const ctx = document.getElementById('chartSekolah').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?= json_encode($label_sering); ?>,
                datasets: [{
                    label: 'Jumlah Kunjungan',
                    data: <?= json_encode($data_sering); ?>,
                    backgroundColor: 'rgba(16, 185, 129, 0.2)',
                    borderColor: '#10b981',
                    borderWidth: 2,
                    borderRadius: 10,
                    barThickness: 50
                }]
            },
            options: {
                responsive: true,
                plugins: { legend: { display: false } },
                scales: {
                    y: { beginAtZero: true, grid: { borderDash: [5, 5] } },
                    x: { grid: { display: false } }
                }
            }
        });
    </script>
</body>
</html>